<!--- Copyright 2025 (c) Dieter Steinwedel 														--->
<!---  																							--->
<!--- Licensed under the Apache License, Version 2.0 (the "License"); 							--->
<!--- you may not use this file except in compliance with the License. 							--->
<!--- You may obtain a copy of the License at 													--->
<!---  																							--->
<!--- http://www.apache.org/licenses/LICENSE-2.0 												--->
<!---  																							--->
<!--- Unless required by applicable law or agreed to in writing, software 						--->
<!--- distributed under the License is distributed on an "AS IS" BASIS, 						--->
<!--- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 					--->
<!--- See the License for the specific language governing permissions and 						--->
<!--- limitations under the License. 															--->

# Developer Documentation
**Welcome to the developer area!**

This application turns your PC with the **hifidom** sound card **DSC8 · MAIN** into a **fully digital AV receiver**. 
We also call this type of device **Digital Sound Control** or **DSC** for short, because unlike a conventional AV receiver, a **DSC** has no loudspeaker connectors but only digital output connectors.

This application introduces a client/server architecture: The PC with the sound card and this application are the server.
You can connect multiple clients simultaneously to the server. 
There are (nearly) no limits, on which device and what OS the clients runs. 
The client can be i.e. a native application, a cell phone app or a web application.

We would like to invite and encourage you to write your own web client for this application.
To do this, you can simply use the API that we present below.

Copy your code into the directory `web/client/default` below the directory in which you have installed this application.
The web client must implement `index.html` in order to start it. 
At the moment, the file `index.html` in this directory is a placeholder and contains only some initial informations.
You can simply replace it.

Please always create a backup of your client.
In one of the next versions we will implement a standard client. 
When installing the new version, the entire content of the directory `web/client/default` will be replaced.
Of course, we will then also implement a mechanism that loads your client from a different directory by means of an appropriate configuration.

Also checkout our [further plans](/ROADMAP) and the [change log](/CHANGELOG).

## License
Copyright 2025 &copy; Dieter Steinwedel

This product is licensed under the Apache License, Version 2.0 (the "License").
You may not use this file except in compliance with the License.
You may obtain a copy of the License [here](/LICENSE).

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Also read the [notice](/NOTICE) for further informations.


## Requirements and Limitations
* This application currently only runs on a actual **64 bit Linux** operation system.
* The hardware architecure of the operation system must be **x86_64** or **aarch64**. The architecture **x86_64** is in common for most AMD<sup>®</sup> and Intel<sup>®</sup> CPUs. The Raspberry Pi<sup>®</sup> 4 & 5 i.e. are compatible to **aarch64**.
* The host system offer sufficient resources i.e. memory, disk space or cpu power. Check the requirements of your Linux distribution.
* The sound card **DSC8 · MAIN** is switched to **full feature mode**.
* The sound card **DSC8 · MAIN** is connected to a USB2 or higher interface with support for the USB **high speed** mode.
* The sound card **DSC8 · MAIN** requires at least one connected input extension card for supporting external input sources.
* Only one sound card **DSC8 · MAIN** per PC is supported.


## IMPORTANT: Before you start developing
If you start developing your own client and you load your client from the file system, you won't be able to connect to the application, because of an [CORS](https://en.wikipedia.org/wiki/Cross-origin_resource_sharing) error.
This is implemented for security reasons.

You can solve this problem, if you create the file `/etc/opt/dsc8-control-user.json` and add following lines:
```
{
	"http_access_control_allow_origin": "*"
}
```
This configuration is only intended for developement. Never use it in production mode.

Also see for more details in the section 'configuration files'.

You must **restart the application** after changing a configuration!

## Concepts
### Configuration files
The application can have multiple configurations files:

1. `dsc8-control.json`: Contains the default configuration for the application. The user should not modify this file, because it is replaced with the next update.
2. `dsc8-control-1.json`: An additional and optional configuration, that can replace (some) configurations of the `dsc8-control.json`. It is loaded after `dsc8-control.json`. The user should not modify this file, because it is replaced with the next update.
3. `dsc8-control-2.json`: An additional and optional configuration, that can replace (some) configurations of the `dsc8-control.json`. It is loaded after `dsc8-control-1.json`. The user should not modify this file, because it is replaced with the next update.
4. `dsc8-control-user.json`: An additional and optional configuration, that can replace (some) configurations of the `dsc8-control.json`. It is loaded after `dsc8-control-2.json`. The *user* can customize here some configuration here. They won't be overwritten with an update.

You can inspect all possible configurations with the endpoint [`/application/config`](#/application/get_app_config).

The configuration files are located in '/etc/dsc8/'.

### Communication
This application provides open and documented programming interfaces for 3rd parties, that are completely based on the [HTTP](https://en.wikipedia.org/wiki/Hypertext_Transfer_Protocol). In particular, the application uses [WebSockets](https://en.wikipedia.org/wiki/WebSocket) and a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). The WebSockets are only used for pushing change notifications to the client. The REST API is primarily intended to change states and settings of the application. 

It is **not a good idea** to use the REST API to **frequently poll** the current control states. In this case the WebSockets are a better choice.

### Error Handling
When a REST request fails, the HTTP response code is 4xx or 5xx. 
The 'x' are placeholder for digits. 
The response body contains a JSON object with informations about the error.
The corresponding data model named [`request_error`](#model-request_error) is defined [here](#model-request_error). 

### Controls
The GUI consists of so-called controls. 
You can use these controls to set the volume or switch the input, for example.
Each control is described by the data structure [`control_info`](#model-control_info).
The data structure contains information about when and how the control should be displayed. 
The data structure also provides information about the current status. 
The individual fields of the data structure [`control_info`](#model-control_info) are described in the section [`schemas`](#model-control_info). 
Just unfold the topic [`control_info`](#model-control_info) for a detailed description.

To get a list of available controls, use the endpoint [`/control/list`](#operations-control-get_control_list).
You also receive the list, when connecting to the WebSocket events.

Now, we would like to discuss certain control types:

The control of type `container` almost combines several controls into a group. 
The field `children` contains the subordinate controls.
A subordinate control may in turn be a control of the `container` type. 
But the other types are also valid to use.

The control of type `channel_layout` informs which channels are present in the data stream.
The channel layout is represented by a 16 bit wide value. 
A channel or speaker position is represented by one bit, but not all bits are used yet:

| Channel Name          |Short Alias | Bit |
|-----------------------|------------|-----|
| Front Left            | FL         | 0   |
| Fron Right            | FR         | 1   |
| Front Center          | FC         | 2   |
| Low Frequency Effects | LFE        | 3   |
| Back Left             | BL         | 4   |
| Back Right            | BR         | 5   |
| reserved              | ---        | 6   |
| reserved              | ---        | 7   |
| reserved              | ---        | 8   |
| Surround Left         | SL         | 9   |
| Surround Right        | SR         | 10  |
| reserved              | ---        | 11  |
| reserved              | ---        | 12  |
| reserved              | ---        | 13  |
| reserved              | ---        | 14  |
| reserved              | ---        | 15  |

If the respective bit for a channel is set, then data for this channel is available in the data stream. 
For example, if the channel layout has the value 3, then the first two bits are set, which means that the channels `Front Left` and `Front Right` are output.

Typically, the channel layout is displayed as an abstract speaker matrix in a room. The active channels are displayed highlighted.

### Authentication and Authorization
An authentication and authorization is yet not implemented, but it will be implemented in the future.

# Predefined shortcuts
| Description             |Shortcut #1 | Shortcut #2         |
|-------------------------|------------|---------------------|
| Volume Down             | \[Vol -\] | \[Alt Gr\]\[&darr;\] |
| Volume Up               | \[Vol +\] | \[Alt Gr\]\[&uarr;\] |
| Toggle Mute on/off      | \[Mute\]  | \[Alt Gr\]\[m\]      |
| Previous Input          | \[Pg Dn\] | \[Alt Gr\]\[&larr;\] |
| Next Input              | \[Pg Up\] | \[Alt Gr\]\[&rarr;\] |
| Toggle Display on/off   | \[Power\] | \[Alt Gr\]\[d\]      |
| Next view               | \[Menu\]  | \[Alt Gr\]\[v\]      |
| Display Brightness Down | \[Br Dn\] | \[Alt Gr\]\[b\]      |
| Display Brightness Up   | \[Br Up\] | \[Alt Gr\]\[n\]      |


# Programming Interfaces
## WebSockets
### Events
When a control element is changed, an event occurs. 
For example, if the volume is changed, the new value of this control is published by an event. 
A client receives all these events when it opens the WebSocket [`/ws/events`](/api/ws_viewer.html?ws=/ws/events).

With the [WebSocket Viewer](/api/ws_viewer.html?ws=/ws/events) you can inspect the messages that this WebSocket sends.

The server always sends an array of [`contol_events`](#model-control_event), even only one control is affected.
A [`control_event`](#model-control_event) can only contain an array of one of the following data types:

* Added controls, 
* updated controls, 
* deleted control ids,
* changed control value or
* changed control visibility.

The events must be processed in the order they are received.

You can also send a [`message`](#model-message) to the server. 
Currently, you only can send a changed control value.
This functionality is redundant to the endpoint [`/control/value`](#/control/set_control_value) with the method `POST`, but sending a change via the WebSocket is more efficient than the endpoint because the endpoint makes a handhake with the server on every request as it is stateless.
The disadvantage compared to the endpoint is that you do not receive a success or error response for any [`message`](#model-message) you send.

### VU Meter
The server calculates the levels over all channels for a vu meter and send the levels as an array of floats about 30 times a second. The values are in dB fullscale.
The channel order in the array is: `Front Left`, `Front Right`, `Center`, `Low Frequency Effects`, `Surround Left`, `Surround Right`, `Back Left` and `Back Right`.

With the [WebSocket Viewer](/api/ws_viewer.html?ws=/ws/vumeter) you can inspect the messages that this WebSocket sends. **Warning:** When music is playing, many messages will be displayed!

### Spectrum Analyzer
This WebSocket will be implemented in the future.

## REST API